 ; Ŀ
 ;   Snake: put entities on snap, change them if necessary.                
 ;   Copyright 1991, 1999, 2003, 2004, 2005 by Rocket Software Ltd.        
 ;   The software equivalent of a fairly large hammer.                     
 ; 

 ; Ŀ
 ;   Sna - put a number on snap.                                           
 ;   Takes two arguments, the number and the matching snap increment.      
 ;   Returns the nearest snap value.                                       
 ; 
 (DEFUN SNA (pax snapx / nxtup nxtdn distup distdn)
  (if (minusp pax)
      (progn
           (setq nxtup (* snapx (fix (/ pax snapx))))       ; next snap pt up
           (setq nxtdn (* snapx (1- (fix (/ pax snapx)))))) ; next snap pt dn
      (progn
           (setq nxtup (* snapx (1+ (fix (/ pax snapx)))))  ; next snap pt up
           (setq nxtdn (* snapx (fix (/ pax snapx))))))     ; next snap pt dn
  (setq distup (abs (- nxtup pax)))               ; distance to next higher
  (setq distdn (abs (- pax nxtdn)))               ; distance to next lower
  (if (> distup distdn)                           ; if further up
      (setq pax nxtdn)                            ; then go down
      (setq pax nxtup))                           ; else go up
 pax)
 ; Ŀ
 ;   Sna end.                                                              
 ; 

 ; Ŀ
 ;   Snak - put an association list on snap.                               
 ;   Takes one argument, a list.                                           
 ;   Assumes that the 2nd and 3rd elements are the X any X coordinates.    
 ;   Returns the modified list.                                            
 ; 
 (DEFUN SNAK (sub / snaps snapx x2 df y2)
  (setq snaps (getvar "snapunit"))
  (setq snapx (car snaps) snapy (cadr snaps))
  (setq x2 (sna (cadr sub) snapx))
  (setq y2 (sna (caddr sub) snapy))
  (if (= (length sub) 3)
      (list (car sub) x2 y2)
      (list (car sub) x2 y2 (cadddr sub))))
 ; Ŀ
 ;   Snak end.                                                             
 ; 

 ; Ŀ
 ;   Snac - put an entity list on snap by a given association number.      
 ;   Takes two arguments, the entity data list and the number.             
 ;   Returns the modified list.                                            
 ; 
 (DEFUN SNAC (asnum entt / snaps snapx fin x2 df y2)
  (setq snaps (getvar "snapunit"))
  (setq snapx (car snaps) snapy (cadr snaps))
  (setq fin (cdr (assoc asnum entt)))
  (setq x2 (sna (car fin) snapx))
  (setq y2 (sna (cadr fin) snapy))
 (subst (cons asnum (list x2 y2)) (assoc asnum entt) entt))
 ; Ŀ
 ;   Snac end.                                                             
 ; 

 ; Ŀ
 ;   PS: put all sublists in an entity/subentity on snap.                  
 ;   Takes one argument, the entity name, returns nothing.                 
 ; 
 (DEFUN PS (enam / entt num sub entt2)
  (setq entt (entget enam))
  (setq num 0)
  (while (setq sub (nth num entt))
         (if (member (car sub) (list 10 11 12 13 14))
             (setq sub (snak sub)))
         (setq entt2 (cons sub entt2))
         (setq num (1+ num)))
  (entmod (reverse entt2))
  (entupd enam)
 (princ))
 ; Ŀ
 ;   PS end.                                                               
 ; 

 ; Ŀ
 ;   Snake.                                                                
 ; 
 (DEFUN SNAKE (ss / snapx enam entt typ typ72 rad txsav)
  (setq num 0)
  (while (setq enam (ssname ss num))              ; first in selection set
         (setq num (1+ num))
         (setq entt (entget enam))                ; entity data
         (setq typ (cdr (assoc 0 entt)))          ; get entity type
         (if (assoc 72 entt)
             (setq typ72 (cdr (assoc 72 entt))))  ; get text justification
 ; Ŀ
 ;   Process entities by type.                                             
 ;   R/M/C aligned text and attdefs.                                       
 ; 
         (cond ((and (or (= typ "TEXT")           ; if text or
                         (= typ "ATTDEF"))        ; attribute and either:
                     (or (= typ72 2)              ; right aligned
                         (= typ72 4)              ; or middle aligned
                         (= typ72 1)))            ; or centred
                (entmod (snac 11 entt)))
 ; Ŀ
 ;   Other text and attdefs.                                               
 ; 
               ((and (or (= typ "TEXT")           ; or text
                         (= typ "ATTDEF"))        ; or an attribute
                     (or (= typ72 3)              ; and either aligned
                         (= typ72 0)              ; or left justified
                         (= typ72 5)))            ; or fit
                (ps enam))
 ; Ŀ
 ;   Mtext.                                                                
 ; 
               ((= typ "MTEXT")
                (entmod (snac 10 entt)))
 ; Ŀ
 ;   Circle or Arc.                                                        
 ; 
               ((member typ '("ARC" "CIRCLE"))
                (setq entt (snac 10 entt))
                (setq rad (cdr (assoc 40 entt)))
                (setq snapx (car (getvar "snapunit")))
                (setq rad (sna rad snapx))
                (if (= rad 0)                     ; radius should not be 0
                    (setq rad snapx))
                (setq entt (subst (cons 40 rad) (assoc 40 entt) entt))
                (entmod entt))
 ; Ŀ
 ;   Dimension.                                                            
 ; 
               ((= typ "DIMENSION")
                (ps enam))
 ; Ŀ
 ;   Insert.                                                               
 ; 
               ((= typ "INSERT")
                (setq fin (cdr (assoc 10 entt)))
                (setq fina (cdr (assoc 10 (snac 10 entt))))
                (command "move" enam "" fin fina))
 ; Ŀ
 ;   Line, Trace, Leader, or Solid.                                        
 ; 
               ((or (= typ "LINE")                ; if a line
                    (= typ "LEADER")              ; or a leader
                    (= typ "TRACE")               ; or a trace
                    (= typ "SOLID"))              ; or a solid
                (ps enam))
 ; Ŀ
 ;   Polyline.                                                             
 ; 
               ((= typ "POLYLINE")
                (setq entt (entget (setq enam (entnext enam)))) ; Next entity
                (setq typ (cdr (assoc 0 entt)))                 ; type
                (while (/= typ "SEQEND")
                       (entmod (snac 10 entt))
                       (entupd (cdr (assoc -1 entt)))
                       (setq entt (entget (setq enam (entnext enam)))) ; Next
                       (setq typ (cdr (assoc 0 entt)))))
 ; Ŀ
 ;   The new lightweight polyline.                                         
 ; 
               ((= typ "LWPOLYLINE")
                (ps enam))
 ; Ŀ
 ;   Anything else.                                                        
 ; 
               (T
                (if (assoc 10 entt)
                    (entmod (snac 10 entt))))))
 (princ))
 ; Ŀ
 ;   Snake end.                                                            
 ; 

 ; Ŀ
 ;   Snake.                                                                
 ; 
 (DEFUN C:SNAKE ( / *error* osmo snapp ss ssf ss1 ss2)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (setvar "snapmode" snapp)
   (command "undo" "end")
   (if shk (prompt shk))
  (princ))
 ; Ŀ
 ;   See if any entities are gripped.                                      
 ; 
  (if (= (type ssgetfirst) 'SUBR)
      (setq ssf (ssgetfirst)))
  (command "undo" "be")
  (setq ss1 (car ssf))
  (setq ss2 (cadr ssf))
  (cond ((or ss1 ss2)
         (if ss1 (snake ss1))
         (if ss2 (snake ss2)))
        (T
         (setq ss (ssget))
         (if ss (snake ss))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))